/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.layout;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.dom.Canvas;
import org.das2.graph.DasAnnotation;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasRow;
import org.das2.util.LoggerManager;

public class LayoutUtil {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.layout");
    private static final boolean ALLOW_EXCESS_SPACE = true;
    private static int count = 0;

    private static boolean maybeSetMaximum(DasDevicePosition c, double need, double norm, double em, int pt) {
        em = Math.floor(em);
        double excess = -1.0 * (c.getEmMaximum() - em);
        if (c.getMaximum() == norm && excess >= 0.0 && excess < 5.0) {
            return false;
        }
        if (Math.abs(c.getEmMaximum() - em) < 0.1 && Math.abs(norm - c.getMaximum()) < 0.001) {
            return false;
        }
        if (Math.abs(em) > 100.0) {
            logger.log(Level.SEVERE, "autolayout failure: {0}em", em);
        }
        c.setMax(norm, em, pt);
        logger.log(Level.FINE, "reset maximum: {0}", c);
        return true;
    }

    private static boolean maybeSetMinimum(DasDevicePosition c, double need, double norm, double em, int pt) {
        em = Math.ceil(em);
        double excess = c.getEmMinimum() - em;
        if (c.getMinimum() == norm && excess >= 0.0 && excess < 4.0) {
            return false;
        }
        if (Math.abs(c.getEmMinimum() - em) < 0.1 && Math.abs(norm - c.getMinimum()) < 0.001) {
            return false;
        }
        if (Math.abs(em) > 100.0) {
            logger.log(Level.SEVERE, "autolayout failure: {0}em", em);
        }
        c.setMin(norm, em, pt);
        logger.log(Level.FINE, "reset minimum: {0}", c);
        return true;
    }

    private static boolean isChildOfMarginColumn(DasColumn marginColumn, DasColumn col) {
        return col == marginColumn || col.getParentDevicePosition() == marginColumn || col.getParentDevicePosition() != null && col.getParentDevicePosition().getParentDevicePosition() == marginColumn;
    }

    private static boolean isChildOfMarginRow(DasRow marginRow, DasRow row) {
        return row == marginRow || row.getParentDevicePosition() == marginRow || row.getParentDevicePosition() != null && row.getParentDevicePosition().getParentDevicePosition() == marginRow;
    }

    public static void autolayout(DasCanvas canvas, DasRow marginRow, DasColumn marginColumn) {
        if (canvas.isValueAdjusting()) {
            logger.info("canvas is adjusting, don't autolayout");
            return;
        }
        logger.fine("enter autolayout");
        double em = marginColumn.getEmSize();
        logger.log(Level.FINE, "autolayout em size: {0}", em);
        int currentBoundsXMin = 90000;
        int currentBoundsXMax = -90000;
        int currentBoundsYMin = 90000;
        int currentBoundsYMax = -90000;
        if (canvas.getWidth() == 0) {
            logger.fine("exit autolayout because canvas.getWidth()==0");
            return;
        }
        ++count;
        boolean tcaAreComing = false;
        boolean foundZeroAreaPlot = false;
        for (DasCanvasComponent cc : canvas.getCanvasComponents()) {
            Rectangle bounds;
            if (cc instanceof DasAnnotation) continue;
            if (cc.isVisible() && LayoutUtil.isChildOfMarginColumn(marginColumn, cc.getColumn())) {
                logger.log(Level.FINER, "here cc= {0}", cc);
                bounds = cc.getBounds();
                logger.log(Level.FINER, "considering for x position (count={0}): {1} {2}", new Object[]{count, cc.getDasName(), bounds});
                if (bounds.width > 0) {
                    logger.finest(String.format("%d %d %d %s", count, bounds.x, bounds.width, cc.toString()));
                    currentBoundsXMin = Math.min(currentBoundsXMin, bounds.x);
                    currentBoundsXMax = Math.max(currentBoundsXMax, bounds.x + bounds.width);
                    if (Math.abs(currentBoundsXMin) > 9999) {
                        logger.log(Level.FINER, "component messes up bounds: {0}", cc);
                    }
                }
            }
            if (!cc.isVisible() || !LayoutUtil.isChildOfMarginRow(marginRow, cc.getRow())) continue;
            bounds = cc.getBounds();
            logger.log(Level.FINER, "considering for y position (count={0}): {1} {2}", new Object[]{count, cc.getDasName(), bounds});
            if (bounds.height > 0) {
                currentBoundsYMin = Math.min(currentBoundsYMin, bounds.y);
                currentBoundsYMax = Math.max(currentBoundsYMax, bounds.y + bounds.height);
            }
            if (cc instanceof DasAxis && ((DasAxis)cc).isDrawTca() && !((DasAxis)cc).isTcaLoaded()) {
                tcaAreComing = true;
            }
            if (bounds.height != 0 || bounds.width != 0 || bounds.x != 0 || bounds.y != 0) continue;
            foundZeroAreaPlot = true;
        }
        logger.finest(String.format("%d %d %d %s", count, currentBoundsXMin, currentBoundsXMax - currentBoundsXMin, "all_together"));
        double MARGIN_LEFT_RIGHT_EM = 1.0;
        boolean changed = false;
        if (Math.abs(currentBoundsXMin) > 9999 || Math.abs(currentBoundsXMax) > 9999 || Math.abs(currentBoundsYMin) > 9999 || Math.abs(currentBoundsYMax) > 9999) {
            logger.fine("invalid bounds returned, returning.");
            return;
        }
        if (currentBoundsYMin > canvas.getHeight() / 2) {
            logger.fine("transitional state where currentBoundsYMin is large.");
            return;
        }
        if (foundZeroAreaPlot) {
            logger.fine("transitional state where plot has no area.");
            return;
        }
        int oldxmin = marginColumn.getDMinimum();
        int needXmin = oldxmin - currentBoundsXMin;
        int oldxmax = marginColumn.getDMaximum();
        int needXmax = currentBoundsXMax - oldxmax;
        int oldymin = marginRow.getDMinimum();
        int needYmin = oldymin - currentBoundsYMin;
        int oldymax = marginRow.getDMaximum();
        int needYmax = currentBoundsYMax - oldymax;
        if ((double)needYmin < -7.0 * em && tcaAreComing) {
            logger.fine("anticipate that TCA data will be loaded, changing xaxis height.");
            needYmin = 0;
        }
        if (needXmax < -120) {
            logger.log(Level.FINE, "needXmax: {0}", needXmax);
            marginColumn.getParent().resizeAllComponents();
            return;
        }
        if (needYmax < -120) {
            logger.log(Level.FINE, "needYmax: {0}", needYmax);
            marginColumn.getParent().resizeAllComponents();
            return;
        }
        logger.log(Level.FINE, "needYmin: {0} needYmax: {1}", new Object[]{needYmin, needYmax});
        if (needYmin < -700) {
            logger.fine("needYmin is less than -700, returning.");
            return;
        }
        changed |= LayoutUtil.maybeSetMinimum((DasDevicePosition)marginColumn, needXmin, 0.0, (double)needXmin / em + MARGIN_LEFT_RIGHT_EM, 0);
        changed |= LayoutUtil.maybeSetMaximum((DasDevicePosition)marginColumn, needXmax, 1.0, (double)(-needXmax) / em - MARGIN_LEFT_RIGHT_EM, 0);
        changed |= LayoutUtil.maybeSetMinimum((DasDevicePosition)marginRow, needYmin, 0.0, (double)needYmin / em, 0);
        if (changed |= LayoutUtil.maybeSetMaximum((DasDevicePosition)marginRow, needYmax, 1.0, (double)(-needYmax) / em, 0)) {
            marginColumn.getParent().resizeAllComponents();
        }
        logger.log(Level.FINER, "exit autolayout, changed={0}", changed);
    }

    public static void normalizeRows(Canvas canvas) {
        ArrayList<DasRow> rows = new ArrayList<DasRow>();
        DasCanvas dasCanvas = canvas.getController().getDasCanvas();
        DasColumn marginColumn = canvas.getMarginColumn().getController().getDasColumn();
        DasRow marginRow = canvas.getMarginRow().getController().getDasRow();
        for (DasCanvasComponent cc : dasCanvas.getCanvasComponents()) {
            if (cc instanceof DasAnnotation || !cc.isVisible() || cc.getColumn() != marginColumn && cc.getColumn().getParentDevicePosition() != marginColumn && (cc.getColumn().getParentDevicePosition() == null || cc.getColumn().getParentDevicePosition().getParentDevicePosition() != marginColumn)) continue;
            rows.add(cc.getRow());
        }
        LayoutUtil.normalizeRows(0.0, marginRow, rows);
    }

    public static void normalizeRows(double em, DasRow marginRow, List<DasRow> rows) {
        int[] dpos;
        HashMap<DasRow, int[]> dposs = new HashMap<DasRow, int[]>();
        for (DasRow r : rows) {
            if (r.getParentDevicePosition() != marginRow) continue;
            dpos = new int[]{r.getDMinimum(), r.getDMaximum()};
            dposs.put(r, dpos);
        }
        marginRow.setMin(0.0, 2.0, 0);
        marginRow.setMax(1.0, -3.0, 0);
        for (DasRow r : rows) {
            if (r.getParentDevicePosition() != marginRow) continue;
            dpos = (int[])dposs.get(r);
            r.setDPosition(dpos[0], dpos[1]);
        }
    }

    public static List<DasDevicePosition> getChildColumns(DasDevicePosition col) {
        DasCanvas canvas = col.getParent();
        ArrayList<DasDevicePosition> result = new ArrayList<DasDevicePosition>();
        for (DasCanvasComponent cc : canvas.getCanvasComponents()) {
            if (cc.getColumn().getParentDevicePosition() != col) continue;
            result.add((DasDevicePosition)cc.getColumn());
        }
        return result;
    }

    public static Rectangle getChildBounds(DasColumn col) {
        DasCanvas canvas = col.getParent();
        Rectangle rect = null;
        for (DasCanvasComponent cc : canvas.getCanvasComponents()) {
            if (cc.getColumn().getParentDevicePosition() != col || !cc.isVisible()) continue;
            Rectangle b = cc.getBounds();
            if (b.height <= 0 || b.width <= 0) continue;
            if (rect == null) {
                rect = cc.getBounds();
                continue;
            }
            rect.add(cc.getBounds());
        }
        return rect;
    }

    public static Rectangle getChildBounds(DasRow row) {
        DasCanvas canvas = row.getParent();
        Rectangle rect = null;
        for (DasCanvasComponent cc : canvas.getCanvasComponents()) {
            if (cc.getRow().getParentDevicePosition() != row || !cc.isVisible()) continue;
            Rectangle b = cc.getBounds();
            if (b.height <= 0 || b.width <= 0) continue;
            if (rect == null) {
                rect = b;
                continue;
            }
            rect.add(b);
        }
        return rect;
    }
}

